@extends('layouts/default')

{{-- Page title --}}
@section('title')
{{$blog->title}}
@parent
@stop

{{-- page level styles --}}
@section('header_styles')
<!--page level css starts-->
<link rel="stylesheet" type="text/css" href="{{ asset('css/frontend/blog.css') }}">
<!--end of page level css-->
@stop

{{-- breadcrumb --}}
@section('top')
<div class="breadcum">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <ol class="breadcrumb">
                    <li>
                        <a href="{{ route('home') }}"> <i class="livicon icon3 icon4" data-name="home" data-size="18"
                                data-loop="true" data-c="#3d3d3d" data-hc="#3d3d3d"></i>Dashboard
                        </a>
                    </li>
                    <li>
                        <i class="livicon icon3" data-name="angle-double-right" data-size="18" data-loop="true"
                            data-c="#01bc8c" data-hc="#01bc8c"></i>
                        <a href="#">Blog Item</a>
                    </li>
                </ol>
                <div class="float-right mt-1">
                    <i class="livicon icon3" data-name="doc-landscape" data-size="20" data-loop="true" data-c="#3d3d3d"
                        data-hc="#3d3d3d"></i> Blog Item
                </div>
            </div>
        </div>
    </div>
</div>
@stop


{{-- Page content --}}
@section('content')
<!-- Container Section Start -->
<div class="container">
    <h2 class="primary my-3">{{$blog->title}}</h2>
    <div class="row content">
        <!-- Business Deal Section Start -->
        <div class="col-sm-8 col-md-8">
            <div class=" thumbnail featured-post-wide img">
                @if($blog->image)
                <img src="{{ URL::to('/uploads/blog/'.$blog->image)  }}" class="img-fluid" alt="Image">
                @endif
                <!-- /.blog-detail-image -->
                <div class="p-3 mb-3 blog-detail-content">
                    <p class="additional-post-wrap">
                        <span class="additional-post">
                            <i class="livicon" data-name="user" data-size="13" data-loop="true" data-c="#5bc0de"
                                data-hc="#5bc0de"></i> by&nbsp;<a
                                href="#">{{$blog->author->first_name . ' ' . $blog->author->last_name}}</a>
                        </span>
                        <span class="additional-post">
                            <i class="livicon" data-name="clock" data-size="13" data-loop="true" data-c="#5bc0de"
                                data-hc="#5bc0de"></i><a href="#"> {{$blog->created_at->diffForHumans()}} </a>
                        </span>
                        <span class="additional-post">
                            <i class="livicon" data-name="comment" data-size="13" data-loop="true" data-c="#5bc0de"
                                data-hc="#5bc0de"></i><a href="#"> {{$blog->comments->count()}} comments</a>
                        </span>
                    </p>
                    <p class="text-justify">
                        {!! $blog->content !!}
                    </p>
                    <div class="blog-detail-image">
                        @if(!empty($blog->summernote_image))
                        <img src="{{URL::to('uploads/blog/'.$blog->summernote_image)}}"
                            class="img-fluid summernote_image" alt="Image">
                        @endif
                    </div>
                    <p>
                        <strong>Tags: </strong>
                        @forelse($blog->tags as $tag)
                        <a href="{{ URL::to('blog/'.mb_strtolower($tag).'/tag') }}">{{ $tag }}</a>,
                        @empty
                        No Tags
                        @endforelse
                    </p>
                </div>
            </div>
            <!-- /the.box .no-border -->
            <!-- Media left section start -->
            <h3 class="comments">{{$blog->comments->count()}} Comments</h3><br />
            <ul class="media-list">
                @foreach($blog->comments as $comment)
                <li class="media">
                    <div class="media-body">
                        <h4 class="media-heading"><i>{{$comment->name}}</i></h4>
                        <p>{{$comment->comment}}</p>
                        <p class="text-danger">
                            <small> {!! $comment->created_at!!}</small>
                        </p>
                    </div>
                </li>
                @endforeach
            </ul>
            <!-- //Media left section End -->
            <!-- Comment Section Start -->
            <h3>Leave a Comment</h3>
            {!! Form::open(['url' => URL::to('blogitem/'.$blog->id.'/comment'), 'method' => 'post', 'class' => 'bf',
            'files'=> true]) !!}

            <div class="form-group {{ $errors->has('name') ? 'has-error' : '' }}">
                {!! Form::text('name', null, ['class' => 'form-control input-lg','required' => 'required',
                'placeholder'=>'Your name']) !!}
                <span class="help-block">{{ $errors->first('name', ':message') }}</span>
            </div>
            <div class="form-group {{ $errors->has('email') ? 'has-error' : '' }}">
                {!! Form::text('email', null, ['class' => 'form-control input-lg','required' => 'required',
                'placeholder'=>'Your email']) !!}
                <span class="help-block">{{ $errors->first('email', ':message') }}</span>
            </div>
            <div class="form-group {{ $errors->has('website') ? 'has-error' : '' }}">
                {!! Form::text('website', null, ['class' => 'form-control input-lg', 'placeholder'=>'Your website']) !!}
                <span class="help-block">{{ $errors->first('website', ':message') }}</span>
            </div>
            <div class="form-group {{ $errors->has('comment') ? 'has-error' : '' }}">
                {!! Form::textarea('comment', null, ['class' => 'form-control input-lg','required' =>
                'required', 'style'=>'height: 200px', 'placeholder'=>'Your comment']) !!}
                <span class="help-block">{{ $errors->first('comment', ':message') }}</span>
            </div>
            <div class="form-group">
                <button type="submit" class="btn btn-success btn-md">
                    <i class="livicon" data-name="comment" data-c="#FFFFFF" data-hc="#FFFFFF" data-size="18"
                        data-loop="true"></i>
                    Submit
                </button>
            </div>
            {!! Form::close() !!}
            <!-- //Comment Section End -->
        </div>
        <!-- //Business Deal Section End -->
        <!-- /.col-sm-9 -->
        <!-- Recent Posts Section Start -->
        <div class="col-sm-4 col-md-4 col-full-width-left">
            <div class="border rounded p-3 the-box">
                <h3 class="small-heading text-center">Recent Posts</h3>
                <ul class="pl-0">
                    <li class="media">
                        <a class="float-left" href="#">
                            <img src="{{ asset('images/authors/avatar1.jpg') }}"
                                class="rounded-circle img-fluid float-left mr-3" alt="riot">
                        </a>
                        <div class="media-body">
                            <h4 class="media-heading primary">
                                <a href="#">Elizabeth Owens at Duis autem vel eum iriure dolor in hendrerit in</a>
                            </h4>
                            <p class="date">
                                <small class="text-danger">2hours ago</small>
                            </p>
                            <p class="small">
                                Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante
                                sollicitudin commodo
                            </p>
                        </div>
                    </li>
                    <hr>
                    <li class="media">
                        <a class="float-left" href="#">
                            <img src="{{ asset('images/authors/avatar4.jpg') }}"
                                class="rounded-circle img-fluid float-left mr-3" alt="riot">
                        </a>
                        <div class="media-body">
                            <h4 class="media-heading primary">
                                <a href="#">Harold Chavez at Duis autem vel eum iriure dolor in hendrerit in</a>
                            </h4>
                            <p class="date">
                                <small class="text-danger">5hours ago</small>
                            </p>
                            <p class="small">
                                Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante
                                sollicitudin commodo
                            </p>
                        </div>
                    </li>
                    <hr>
                    <li class="media">
                        <a class="float-left" href="#">
                            <img src="{{ asset('images/authors/avatar5.jpg') }}"
                                class="rounded-circle img-fluid float-left mr-3" alt="riot">
                        </a>
                        <div class="media-body">
                            <h4 class="media-heading primary">
                                <a href="#">Mihaela Cihac at Duis autem vel eum iriure dolor in hendrerit in</a>
                            </h4>
                            <p class="date">
                                <small class="text-danger">10hours ago</small>
                            </p>
                            <p class="small">
                                Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante
                                sollicitudin commodo
                            </p>
                        </div>
                    </li>
                </ul>
            </div>
            <!-- /.the-box .bg-primary .no-border .text-center .no-margin -->
        </div>
        <!-- //Recent Posts Section End -->
        <!-- /.col-sm-3 -->
    </div>
</div>
<!-- //container Section End -->
@stop
